;
;								EJEMPLO 6
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Mquina de envasado
;
;Dos rels "M1" (RB0) y "M2" (RB1) gobiernan dos motores que arrastran dos cintas 
;transportadoras. "M1" (RB0) transporta piezas y "M2" (RB1) embalajes. Un sensor "DP" (RA1) 
;detecta el paso de piezas y, otro "DE" (RA2), detecta el correcto posicionamiento de un 
;envase. Al detectarse el paso de 10 piezas, el envase se considera lleno, se activa una 
;seal acstica "A" (RB2) y, la cinta que transporta embalajes, se desplaza hasta situar un 
;nuevo envase vaco. En este momento se desactiva la seal acstica "A"(RB2) y nuevamente 
;avanza la cinta de piezas repitindose as el ciclo. Un interruptor "I" (RA0) activa o 
;no a todo el sistema.
	
		List	p=16F876A	;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

Conta_pieza	equ	0x20		;Variable de N de piezas
                    
;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

;Estos y otros valores se pueden modificar segn las necesidades

			org		0x00
			goto	Inicio		;Vector de reset
			org		0x05	

Inicio		clrf 	PORTB		;Borra los latch de salida
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			movlw	0x06
			movwf	ADCON1		;Puerta A digital
			movlw	b'00011111'		
			movwf	TRISA		;Puerta A se configura como entrada
			bcf		STATUS,RP0	;Selecciona banco 0			                                                                         

Loop_0		clrf	PORTB		;Desconecta las salidas					
Loop:		movlw	d'10'
			movwf	Conta_pieza	;Inicia variable con N de piezas a contar
			btfss	PORTA,0		;Chequea el estado del interruptor I
			goto	Loop_0		;Est en OFF, sistema parado				

			bcf		PORTB,0		;Avance de piezas en OFF
			bsf		PORTB,1		;Avance de envases en ON
										
No_envase	btfss	PORTA,2		;Envase en posicin ??
			goto	No_envase	;No.					

			bsf		PORTB,0		;Si. Avance de piezas en ON
			bcf		PORTB,1		;Avance de envases en OFF
			bcf		PORTB,2		;Acstico en OFF 
					
;Esta secuencia de instrucciones, espera que una pieza pase por el sensor "DP" en
;su totalidad generando un pulso con transicin 1-0-1

Pieza_0		btfsc	PORTA,1		;Llega la pieza (flanco descendente)??
			goto	Pieza_0		;Todava no

Pieza_1		btfss	PORTA,1		;Si.Ha pasado la pieza frente al sensor "DP" (flanco ascendente)??
			goto	Pieza_1		;Todava no					

			decfsz	Conta_pieza,F	;Ahora si. Decrementa contador de piezas
			goto	Pieza_0		;Esperar paso de una nueva					

pieza		bcf		PORTB,0		;Han pasado 10, avance de piezas en OFF
			bsf		PORTB,1		;Avance de envases en ON
			bsf		PORTB,2		;Acstico en ON					

Si_envase	btfsc	PORTA,2		;Sigue el mismo envase posicionado ??
			goto	Si_envase	;Todava si				
			goto	Loop		;Ahora no

			end					;Fin del programa fuente
